/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.security;

import filenet.vw.api.VWSecurityDomain;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class VWDomainListCellRenderer
extends JLabel
implements ListCellRenderer {
    public VWDomainListCellRenderer() {
        this.setOpaque(true);
    }

    public static String getDomainName(VWSecurityDomain secDomain) {
        if (secDomain != null) {
            String name = secDomain.toString();
            int nIndex = name.indexOf(46);
            if (nIndex > 0) {
                name = name.substring(0, nIndex);
            }
            return name;
        }
        return null;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setFont(list.getFont());
        this.setEnabled(list.isEnabled());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value != null && value instanceof VWSecurityDomain) {
            VWSecurityDomain secDomain = (VWSecurityDomain)value;
            this.setText(VWDomainListCellRenderer.getDomainName(secDomain));
            this.setToolTipText(secDomain.toString());
        } else if (value != null && value instanceof String) {
            this.setText((String)value);
            this.setToolTipText(null);
        }
        return this;
    }
}

